using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class MovieCastBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            MicroFour.StrataFrame.Business.BusinessParentRelationship BusinessParentRelationship1 = new MicroFour.StrataFrame.Business.BusinessParentRelationship();
            MicroFour.StrataFrame.Business.RequiredField RequiredField1 = new MicroFour.StrataFrame.Business.RequiredField();
            //
            //MovieCastBO
            //
            BusinessParentRelationship1.ForeignKeyField = new string[] { "mc_mv_pk" };
            BusinessParentRelationship1.ParentBusinessObjectType = "StrataFlix.Business.MoviesBO";
            BusinessParentRelationship1.ParentPrimaryKeyField = new string[] { "mv_pk" };
            this.ParentRelationship = BusinessParentRelationship1;
            RequiredField1.FieldName = "mc_pl_pk";
            RequiredField1.FieldType = System.Data.SqlDbType.Int;
            this.RequiredFields.AddRange(new MicroFour.StrataFrame.Business.RequiredField[] { RequiredField1 });
            this.RowVersionOrTimestampColumn = "mc_Version";
            this.UpdateConcurrencyType = MicroFour.StrataFrame.Data.ConcurrencyTypeOptions.OptimisticRowVersion;

        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[mc_pk],[mc_mv_pk],[mc_pl_pk],[mc_CastType],[mc_CharacterName],[mc_CreatedAt],[mc_CreatedBy],[mc_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "mc_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "MovieCast";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("mc_pk", typeof(System.Int32)),
new DataColumn("mc_mv_pk", typeof(System.Int32)),
new DataColumn("mc_pl_pk", typeof(System.Int32)),
new DataColumn("mc_CastType", typeof(System.Int32)),
new DataColumn("mc_CharacterName", typeof(System.String)),
new DataColumn("mc_CreatedAt", typeof(System.DateTime)),
new DataColumn("mc_CreatedBy", typeof(System.Int32)),
new DataColumn("mc_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(MovieCastBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(MovieCastBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mc_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["mc_pk"];
            }
            set
            {
                this.CurrentRow["mc_pk"] = value;
            }
        }

        /// <summary>
        /// Movie Foreign Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Movie Foreign Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mc_mv_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["mc_mv_pk"];
            }
            set
            {
                this.CurrentRow["mc_mv_pk"] = value;
            }
        }

        /// <summary>
        /// People Foreign Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("People Foreign Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mc_pl_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["mc_pl_pk"];
            }
            set
            {
                this.CurrentRow["mc_pl_pk"] = value;
            }
        }

        /// <summary>
        /// Type of casting or role
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Type of casting or role"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public MovieCastType mc_CastType
        {
            get
            {
                return (MovieCastType)this.CurrentRow["mc_CastType"];
            }
            set
            {
                this.CurrentRow["mc_CastType"] = value;
            }
        }

        /// <summary>
        /// Character Name
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Character Name"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String mc_CharacterName
        {
            get
            {
                return (System.String)this.CurrentRow["mc_CharacterName"];
            }
            set
            {
                this.CurrentRow["mc_CharacterName"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime mc_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["mc_CreatedAt"];
            }
            set
            {
                this.CurrentRow["mc_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// User Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("User Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mc_CreatedBy
        {
            get
            {
                return (System.Int32)this.CurrentRow["mc_CreatedBy"];
            }
            set
            {
                this.CurrentRow["mc_CreatedBy"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 mc_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["mc_Version"];
            }
            set
            {
                this.CurrentRow["mc_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum MovieCastBOFieldNames
        {
            mc_pk,
            mc_mv_pk,
            mc_pl_pk,
            mc_CastType,
            mc_CharacterName,
            mc_CreatedAt,
            mc_CreatedBy,
            mc_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(MovieCastBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<MovieCastBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<MovieCastBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<MovieCastBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the MovieCastBO class.
        /// </summary>
        static MovieCastBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(13);
            _PropertyDescriptors.Add("mc_pk", new FieldDescriptor(MovieCastBOFieldNames.mc_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("mc_mv_pk", new FieldDescriptor(MovieCastBOFieldNames.mc_mv_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("mc_pl_pk", new FieldDescriptor(MovieCastBOFieldNames.mc_pl_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("mc_CastType", new FieldDescriptor(MovieCastBOFieldNames.mc_CastType, typeof(MovieCastType)));
            _PropertyDescriptors.Add("mc_CharacterName", new FieldDescriptor(MovieCastBOFieldNames.mc_CharacterName, typeof(System.String)));
            _PropertyDescriptors.Add("mc_CreatedAt", new FieldDescriptor(MovieCastBOFieldNames.mc_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("mc_CreatedBy", new FieldDescriptor(MovieCastBOFieldNames.mc_CreatedBy, typeof(System.Int32)));
            _PropertyDescriptors.Add("mc_Version", new FieldDescriptor(MovieCastBOFieldNames.mc_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(8);
            _AllFieldsList.Add("mc_pk");
            _AllFieldsList.Add("mc_mv_pk");
            _AllFieldsList.Add("mc_pl_pk");
            _AllFieldsList.Add("mc_CastType");
            _AllFieldsList.Add("mc_CharacterName");
            _AllFieldsList.Add("mc_CreatedAt");
            _AllFieldsList.Add("mc_CreatedBy");
            _AllFieldsList.Add("mc_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(8);
            _FieldDbTypes.Add("mc_pk", DbType.Int32);
            _FieldDbTypes.Add("mc_mv_pk", DbType.Int32);
            _FieldDbTypes.Add("mc_pl_pk", DbType.Int32);
            _FieldDbTypes.Add("mc_CastType", DbType.Int32);
            _FieldDbTypes.Add("mc_CharacterName", DbType.String);
            _FieldDbTypes.Add("mc_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("mc_CreatedBy", DbType.Int32);
            _FieldDbTypes.Add("mc_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(9);
            _FieldEnums.Add("mc_pk", MovieCastBOFieldNames.mc_pk);
            _FieldEnums.Add("mc_mv_pk", MovieCastBOFieldNames.mc_mv_pk);
            _FieldEnums.Add("mc_pl_pk", MovieCastBOFieldNames.mc_pl_pk);
            _FieldEnums.Add("mc_CastType", MovieCastBOFieldNames.mc_CastType);
            _FieldEnums.Add("mc_CharacterName", MovieCastBOFieldNames.mc_CharacterName);
            _FieldEnums.Add("mc_CreatedAt", MovieCastBOFieldNames.mc_CreatedAt);
            _FieldEnums.Add("mc_CreatedBy", MovieCastBOFieldNames.mc_CreatedBy);
            _FieldEnums.Add("mc_Version", MovieCastBOFieldNames.mc_Version);
            _FieldEnums.Add("CUSTOM_FIELD", MovieCastBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(8);
            _FieldLengths.Add("mc_pk", 4);
            _FieldLengths.Add("mc_mv_pk", 4);
            _FieldLengths.Add("mc_pl_pk", 4);
            _FieldLengths.Add("mc_CastType", 4);
            _FieldLengths.Add("mc_CharacterName", 256);
            _FieldLengths.Add("mc_CreatedAt", 8);
            _FieldLengths.Add("mc_CreatedBy", 4);
            _FieldLengths.Add("mc_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(8);
            _FieldNativeDbTypes.Add("mc_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mc_mv_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mc_pl_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mc_CastType", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mc_CharacterName", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("mc_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("mc_CreatedBy", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("mc_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(8);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the MovieCastBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<MovieCastBOFieldNames>
        {
            public FieldDescriptor(MovieCastBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(MovieCastBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case MovieCastBOFieldNames.mc_pk:
                        return ((MovieCastBO)component).mc_pk;
                    case MovieCastBOFieldNames.mc_mv_pk:
                        return ((MovieCastBO)component).mc_mv_pk;
                    case MovieCastBOFieldNames.mc_pl_pk:
                        return ((MovieCastBO)component).mc_pl_pk;
                    case MovieCastBOFieldNames.mc_CastType:
                        return ((MovieCastBO)component).mc_CastType;
                    case MovieCastBOFieldNames.mc_CharacterName:
                        return ((MovieCastBO)component).mc_CharacterName;
                    case MovieCastBOFieldNames.mc_CreatedAt:
                        return ((MovieCastBO)component).mc_CreatedAt;
                    case MovieCastBOFieldNames.mc_CreatedBy:
                        return ((MovieCastBO)component).mc_CreatedBy;
                    case MovieCastBOFieldNames.mc_Version:
                        return ((MovieCastBO)component).mc_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case MovieCastBOFieldNames.mc_pk:
                        ((MovieCastBO)component).mc_pk = (System.Int32)value;
                        break;
                    case MovieCastBOFieldNames.mc_mv_pk:
                        ((MovieCastBO)component).mc_mv_pk = (System.Int32)value;
                        break;
                    case MovieCastBOFieldNames.mc_pl_pk:
                        ((MovieCastBO)component).mc_pl_pk = (System.Int32)value;
                        break;
                    case MovieCastBOFieldNames.mc_CastType:
                        ((MovieCastBO)component).mc_CastType = (MovieCastType)value;
                        break;
                    case MovieCastBOFieldNames.mc_CharacterName:
                        ((MovieCastBO)component).mc_CharacterName = (System.String)value;
                        break;
                    case MovieCastBOFieldNames.mc_CreatedAt:
                        ((MovieCastBO)component).mc_CreatedAt = (System.DateTime)value;
                        break;
                    case MovieCastBOFieldNames.mc_CreatedBy:
                        ((MovieCastBO)component).mc_CreatedBy = (System.Int32)value;
                        break;
                    case MovieCastBOFieldNames.mc_Version:
                        ((MovieCastBO)component).mc_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
